# 로컬 스토리지, 세션 스토리지, 쿠키의 공통점과 차이점

- http는 **stateless/connectionless**의 특성을 지님. 즉, 비연결성/무상태성을 특징으로 인해 서버와 클라이언트가요청에 대한 응답을 주고 연결을 끊고 나면 서버는 클라이언트에 대한 정보를 기억하지 않음.
    
    이러한 http의 특성을 보완하고자 등장한 것이 **‘쿠키’**
    

- **쿠키** :
    - 쿠키는 클라이언트(브라우저)에 저장되는 키와 같이 들어있는 작은 파일
    - 클라이언트의 상태 정보를 로컬에 저장했다가 참조한다.
    - 클라이언트에 300개까지의 쿠키 저장이 가능하고, 하나의 도메인당 20개의 값만 가질 수 있으며, 하나의 쿠키값은 4KB까지 저장이 가능하다.
    - Response Header에 Set-Cookie 속성을 사용하면 클라이언트에 쿠키를 만들 수 있다.
        
        ![스크린샷 2023-08-05 오후 9.37.36.png](%E1%84%85%E1%85%A9%E1%84%8F%E1%85%A5%E1%86%AF%20%E1%84%89%E1%85%B3%E1%84%90%E1%85%A9%E1%84%85%E1%85%B5%E1%84%8C%E1%85%B5,%20%E1%84%89%E1%85%A6%E1%84%89%E1%85%A7%E1%86%AB%20%E1%84%89%E1%85%B3%E1%84%90%E1%85%A9%E1%84%85%E1%85%B5%E1%84%8C%E1%85%B5,%20%E1%84%8F%E1%85%AE%E1%84%8F%E1%85%B5%E1%84%8B%E1%85%B4%20%E1%84%80%E1%85%A9%E1%86%BC%E1%84%90%E1%85%A9%E1%86%BC%E1%84%8C%E1%85%A5%E1%86%B7%E1%84%80%E1%85%AA%2068b058cc3ad84ec1b83f9615ffdedf47/%25EC%258A%25A4%25ED%2581%25AC%25EB%25A6%25B0%25EC%2583%25B7_2023-08-05_%25EC%2598%25A4%25ED%259B%2584_9.37.36.png)
        
    - 크롬에서 확인할 수 있는 쿠키의 예시
    
    - 주로 서버에서 사용되며 http 요청시 headers에 실려서 서버로 전송된다.
    - 이 때 같은 도메인에서 만들어진 쿠키만 전송됨.
    - 만료 기한이 있는 저장소로 브라우저를 닫아도 설정된 만료 날짜까지 유지되거나 만료 날짜를 지정하지 않으면 세션 동안만 유지된다.
    - Expires 혹은 Max-Age를 통해 만료 기간을 정할 수 있음. 만약 Expires와 Max-Age가 동시에 존재한다면 Expires는 무시됨.

- 쿠키의 분류 (만료기간 기준)
    - 영구 쿠키 : 만료 기간 O, 만료 기간이 끝난 후 삭제
    - 세션 쿠키 : 만료 기간 X, 브라우저 종료 시 삭제
    

- 쿠키의 분류
    - 퍼스트파티 쿠키(First party Cookie) : 같은 도메인에서 생성된 쿠키를 의미. (서브 도메인에서 생성된 쿠키 또한 포함)
    - 서드파티 쿠키 (Third party Cookie) : 다른 도메인에서 생성된 쿠키. 스크립트 뿐 아니라 이미지, 폰트 등 다른 도메인으로 요청을 해야 하는 경우에 언제든지 생성될 수 있음.

![스크린샷 2023-08-04 오후 3.52.00.png](%E1%84%85%E1%85%A9%E1%84%8F%E1%85%A5%E1%86%AF%20%E1%84%89%E1%85%B3%E1%84%90%E1%85%A9%E1%84%85%E1%85%B5%E1%84%8C%E1%85%B5,%20%E1%84%89%E1%85%A6%E1%84%89%E1%85%A7%E1%86%AB%20%E1%84%89%E1%85%B3%E1%84%90%E1%85%A9%E1%84%85%E1%85%B5%E1%84%8C%E1%85%B5,%20%E1%84%8F%E1%85%AE%E1%84%8F%E1%85%B5%E1%84%8B%E1%85%B4%20%E1%84%80%E1%85%A9%E1%86%BC%E1%84%90%E1%85%A9%E1%86%BC%E1%84%8C%E1%85%A5%E1%86%B7%E1%84%80%E1%85%AA%2068b058cc3ad84ec1b83f9615ffdedf47/%25EC%258A%25A4%25ED%2581%25AC%25EB%25A6%25B0%25EC%2583%25B7_2023-08-04_%25EC%2598%25A4%25ED%259B%2584_3.52.00.png)

- 쿠키의 구성 요소 :
    - 이름(Name) : 각각의 쿠키를 구별하는 데 사용되는 이름
    - 값(Value) : 쿠키의 이름과 관련된 값
    - 유효시간(Expires): 쿠키의 유지시간
    - 도메인(Domain): 쿠키를 전송할 도메인
    - 경로(Path): 쿠키를 전송할 요청 경로
    
    - 쿠키의 메서드
        
        ```jsx
        //쿠키 설정
        document.cookie = 'username=kim_hyewon'; expires=Fri, 3 Aug 2023 23:59:59 UTC; path=/';
        
        //쿠키 가져오기
        const cookies = document.cookie;
        ```
        
    - 쿠키의 동작 방식
        1. 클라이언트가 페이지를 요청한다
        2. 서버에서 쿠키를 생성한다
        3. HTTP 헤더에 쿠키를 포함시켜 응답한다
        4. 브라우저가 종료되어도 쿠키 만료 기간이 있다면 클라이언트에서 보관한다.
        5. 같은 요청을 할 경우 HTTP 헤더에 쿠키를 함께 보낸다.
        6. 서버에서 쿠키를 읽어 이전 상태 정보를 변경 할 필요가 있을 때 쿠키를 업데이트하여 변경된 쿠키를 HTTP 헤더에 포함시켜 응답한다. 
    
    쿠키의 문제점 
    
    - CSRF: 쿠키가 자동으로 전송된다는 것을 이용하여 사이트에 로그인 되어 있는 사용자에게 악성스크립트를 실행시켜 비밀번호 변경, 결제 요청을 하는 것
    - XSS : 악성 스크립트를 실행시켜 사용자의 토큰과 같이 민감한 정보를 탈취하는 것.
    - 부족한 저장 용량
    - HTTP 요청 시 자동으로 모든 쿠키 전송  → 불필요한 트래픽 증가
    
    이러한 문제점을 해결하기 위해 **웹스토리지**가 HTML5에 등장.
    
    **웹 스토리지의 특징**
    
    - 5MB의 저장용량 → 쿠키의 부족한 저장 용량 문제 해결
    - 요청 시 자동으로 Headers에 전송하지 않음 → 쿠키의 CSRF, 트래픽 문제 해결
    - 쿠키와 마찬가지로 문자열만 저장 가능 → 직렬화를 통해 객체 저장 가능
    - 대부분의 브라우저는 웹스토리지를 지원하지만 버전에 따라 웹스토리지를 지원하지 않을 수도 있고,
    - 웹스토리지를 지원한다고 해도 비활성화 설정을 지원하기도 하여 에러가 발생할 수 있음. (예를 들어 사파리 시크릿 모드 시 웹 스토리지 할당량이 0으로 제한되어 있어 할당량 초과 에러가 발생하게 됨).
        - 따라서 웹 스토리지 사용시 에러 처리를 꼭 해야 함.
    
    웹 스토리지의 분류
    
    - **로컬 스토리지** : 사용자가 지우지 않는 한 데이터 **영구적**
    - **세션 스토리지** : 윈도우/탭 닫을 시 내용 제거
    
    **** 로컬 스토리지와 세션 스토리지의 차이점은 데이터의 영구성**
    
    지속적으로 필요한 데이터(자동 로그인 등)는 로컬 스토리지에 저장하고, 잠깐 동안 필요한 정보(일회성 로그인 정보 등)는 세션 스토리지에 저장하는 것이 좋다. 하지만 비밀번호같은 중요한 정보는 절대 저장해서는 안된다. 클라이언트에 저장하는 것이기 때문에 보안에 취약하기 때문.
    
    세션이란?
    
    - 세션은 쿠키를 기반하고 있지만, 사용자 정보 파일을 브라우저에 저장하는 쿠키와 달리 세션은 서버 측에서 관리
    - 서버에서는 클라이언트를 구분하기 위해 세션 ID를 부여하며 웹 브라우저가 서버에 접속해서 브라우저를 종료할 때까지 인증 상태를 유지
    - 사용자에 대한 정보를 서버에 두기 때문에 쿠키보다 보안에 좋지만, 사용자가 많아질수록 서버 메모리를 많이 차지하게 됨.
    - 즉 동접자 수가 많은 웹 사이트인 경우 서버에 과부하를 주게 되므로 성능 저하의 요인이 됨.
    - 클라이언트가 Request를 보내면, 해당 서버의 엔진이 클라이언트에게 유일한 ID를 부여하는데 이것이 세션 ID
    
    - 로컬 스토리지의 메소드
        
        ```jsx
        //로컬 스토리지에 데이터 저장
        localStorage.setItem('username', 'kim_hyewon');
        
        //데이터 가져오기(조회)
        const username = localStorage.getItem('username');
        
        //데이터 삭제
        localStorage.removeItem('username');
        
        //스토리지 전체 삭제
        localStorage.clear();
        ```
        
    - 세션 스토리지의 메소드
        
        ```jsx
        //데이터 저장
        sessionStorage.setItem('language', 'english');
        
        //데이터 가져오기
        const language = sessionStorage.getItem('language');
        
        //데이터 삭제
        sessionStorage.removeItem('language');
        ```
        
    
    웹 스토리지의 **문제점**
    
    - XSS에 취약 (javascript를 사용하기 때문)
    - 독립된 스토리지로 브라우저 혹은 탭 간 공유 불가능
    - 만료 시간 설정 불가
    - 동기적으로 실행되기 때문에 메인 스레드를 블로킹 할 수 있음
    

쿠키 & 웹 스토리지의 사용 예시

- 쿠키 : 기간을 설정해야 하거나, 자동으로 서버로 전송되어야 하는 작은 용량의 데이터의 경우 사용할 수 있음.
    
    ex) n일 동안 보지 않기/ 비로그인 장바구니
    

- 로컬 스토리지: 브라우저 종료 시 유지
    
    ex) 사용자 설정 저장/ 글 임시 저장
    
- 세션 스토리지 : 탭 종료시 삭제되어도 괜찮은 정보
    
    ex) 이전 페이지 저장/ 이전 스크롤 위치 저장
